
public class Sudoku
{
    private Feld [] [] felder;

    private Feld aktuellesFeld;

    public Sudoku(int [] [] pFelder)
    {
        aktuellesFeld = null;

        felderInitialisieren(pFelder);
    }

    private void felderInitialisieren(int [] [] pFelder)
    {
        felder = new Feld [9] [9];
        
        if (pFelder.length == gibSeitenLaenge() && pFelder[5].length == 9)
        {
            for (int y = 0; y < pFelder.length; y++)
            {
                for (int x = 0; x < pFelder.length; x++)
                {
                    if (pFelder [x] [y] > 0 && pFelder [x] [y] <= gibSeitenLaenge())
                    {
                        felder [x] [y] = new Feld(false, pFelder [x] [y]);
                    }
                    else if (pFelder [x] [y] == 0)
                    {
                        felder [x] [y] = new Feld(true, pFelder [x] [y]);
                    }
                    else
                    {
                        System.out.println("Feld falsch initialisiert");
                    }
                }
            }
        }
    }

    public int gibZahl(int pX, int pY)
    {
        int tmp = -1;
        if (pX >= 0 && pX <gibSeitenLaenge())
        {
            if ((pY >= 0 && pY <gibSeitenLaenge()))
            {
                tmp = felder [pX] [pY].getZahl();
            }
            else
            {
                System.out.println(" sudoku.gibZahl(int pX, int pY) Y Fehler");
            }
        }
        else
        {
            System.out.println(" sudoku.gibZahl(int pX, int pY) X Fehler");
        }
        return tmp;
    }

    /**
     * aendert das aktuelle Feld
     * nur das aktuelle feld darf ueberschrieben werden
     */
    public void setzeAktuellesFeld (int pX, int pY)
    {
        if ((pX >= 0 && pX < gibSeitenLaenge()) && (pY >= 0 && pY < gibSeitenLaenge()))
        {
            aktuellesFeld = felder[pX] [pY];
        }
    }

    public void setzeZahlAktuellesFeld (int pWert)
    {
        if (pWert >= 0 && pWert <= gibSeitenLaenge())
        {
            aktuellesFeld.setzeZahl (pWert);
        }
    }

    public boolean istAktuellesFeld(int pX, int pY)
    {
        boolean istRichtig = false;
        if (aktuellesFeld != null && felder != null && (pX >= 0 && pX < gibSeitenLaenge()) && (pY >= 0 && pY < gibSeitenLaenge()))
        {
            if (felder [pX] [pY] == aktuellesFeld)
            {
                istRichtig = true;
            }
        }
        return istRichtig;
    }

    public int gibSeitenLaenge()
    {
        return felder.length;
    }

    public boolean istVeraenderbar(int pX, int pY)
    {
        return felder [pX] [pY].getUeberschreibbar();
    }

    public Feld gibFeld (int pX, int pY)
    {
        return felder [pX] [pY];
    }

    public void setzeFeld (Feld [] [] pFeld)
    {
        felder = pFeld;
    }

    public boolean besitztFeld()
    {
        return !(felder == null);
    }

    @Override public Sudoku clone()
    {
        Sudoku neuesSudoku = null;
        int [] [] feldertmp = new int [gibSeitenLaenge()] [gibSeitenLaenge()];
        for (int y = 0; y < gibSeitenLaenge(); y++)
        {
            for (int x = 0; x < gibSeitenLaenge(); x++)
            {
                feldertmp [x] [y] = this.gibZahl(x, y);
            }
        }
        neuesSudoku = new Sudoku(feldertmp);
        return neuesSudoku;
    }
}
